namespace win
  #include "windows.bi"
end namespace
using win

declare function WinMain ( _
  byval hInstance as win.hInstance, _
  byval hPrevInstance as win.hInstance, _
  byval lpCmdLine as win.LPSTR, _
  byval nCmdShow as integer ) as integer
end WinMain( win.GetModuleHandle( NULL ), NULL, command, SW_NORMAL )

const as string g_szClassName = "myWindowClass"

function WndProc( _
  byval hwnd as win.HWND, _
  byval msg as win.UINT, _
  byval wParam as win.WPARAM, _
  byval lParam as win.LPARAM) as win.LRESULT
  
  select case msg
    case WM_CLOSE
      win.DestroyWindow(hwnd)
    case WM_DESTROY
      win.PostQuitMessage(0)
    case else
      return win.DefWindowProc(hwnd, msg, wParam, lParam)
  end select
  return 0
  
end function

function WinMain ( _
  byval hInstance as win.hInstance, _
  byval hPrevInstance as win.hInstance, _
  byval lpCmdLine as win.LPSTR, _
  byval nCmdShow as integer ) as integer
  
  dim as win.WNDCLASSEX wc
  dim as win.HWND hwnd
  dim as win.MSG msg
  
	with wc
    .cbSize        = sizeof(win.WNDCLASSEX)
    .style         = 0
    .lpfnWndProc   = @WndProc()
    .cbClsExtra    = 0
    .cbWndExtra    = 0
    .hInstance     = hInstance
    .hIcon         = LoadIcon(NULL, IDI_APPLICATION)
    .hCursor       = LoadCursor(NULL, IDC_ARROW)
    .hbrBackground = cast(HBRUSH, (COLOR_WINDOW+1))
    .lpszMenuName  = NULL
    .lpszClassName = strptr(g_szClassName)
    .hIconSm       = LoadIcon(NULL, IDI_APPLICATION)
	end with

  if win.RegisterClassEX( @wc ) = 0 then
    win.MessageBox( NULL, "Window Registration Failed!", "Error!", MB_ICONEXCLAMATION OR MB_OK )
    return 0
  end if

  hwnd = win.CreateWindowEx( _
    WS_EX_CLIENTEDGE, _
    g_szClassName, _
    "The title of my window", _
    WS_OVERLAPPEDWINDOW, _
    CW_USEDEFAULT, CW_USEDEFAULT, 240, 120, _
    NULL, NULL, hInstance, NULL ) 

  if ( hwnd = NULL ) then
    win.MessageBox(NULL, "Window Creation Failed!", "Error!", MB_ICONEXCLAMATION or MB_OK )
    return 0
  end if
  
  win.ShowWindow( hwnd, nCmdShow )
  win.UpdateWindow( hwnd )
  
  while ( win.GetMessage( @Msg, NULL, 0, 0) > 0 )
    win.TranslateMessage(@Msg)
    win.DispatchMessage(@Msg)
  wend
  return Msg.wParam

end function